<?
/**
 * @package     DOCman
 * @copyright   Copyright (C) 2012 Timble CVBA. (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */
defined('KOOWA') or die; ?>

<? if ($can_delete): ?>
<ktml:script src="media://com_docman/js/site/items.js" />
<? endif; ?>

<? if (!empty($can_add)): ?>
    <?= $this->helper('behavior.modal'); ?>
<? endif; ?>

<?= $this->helper('ui.load'); ?>



<? // RSS feed ?>
<link href="<?=$this->route('format=rss');?>" rel="alternate" type="application/rss+xml" title="RSS 2.0" />


<? if ($params->track_downloads): ?>
    <?= $this->helper('behavior.download_tracker'); ?>
<? endif; ?>

<div class="docman_table_layout docman_table_layout--default">

    <? // Page heading ?>
    <? if ($params->get('show_page_heading')): ?>
        <h1 class="docman_page_heading">
            <?= $this->escape($params->get('page_heading')); ?>
        </h1>
    <? endif; ?>

    <? // Toolbar ?>
    <ktml:toolbar type="actionbar">

    <? // Category ?>
    <? if (($params->show_icon && $category->icon)
    || ($params->show_category_title)
    || ($params->show_image && $category->image)
    || ($category->description_full && $params->show_description)
    ): ?>
    <div class="docman_category">

        <? // Header ?>
        <? if ($params->show_category_title && $category->title): ?>
        <h3 class="koowa_header">
            <? // Header image ?>
            <? if ($params->show_icon && $category->icon): ?>
                <span class="koowa_header__item koowa_header__item--image_container">
                    <?= $this->import('com://site/docman.document.icon.html', array('icon' => $category->icon, 'class' => ' k-icon--size-medium')) ?>
                </span>
            <? endif ?>

            <? // Header title ?>
            <span class="koowa_header__item">
                <span class="koowa_wrapped_content">
                    <span class="whitespace_preserver">
                        <?= $this->escape($category->title); ?>
                    </span>
                </span>
            </span>
        </h3>
        <? endif; ?>

        <? // Edit area | Import partial template from category view ?>
        <?= $this->import('com://site/docman.category.manage.html', array('category' => $category)) ?>

        <? // Category image ?>
        <? if ($params->show_image && $category->image): ?>
            <?= $this->helper('behavior.thumbnail_modal'); ?>
            <a class="docman_thumbnail thumbnail" href="<?= $category->image_path ?>">
                <img src="<?= $category->image_path ?>" alt="<?= $this->escape($category->title); ?>" />
            </a>
        <? endif ?>

        <? // Category description full ?>
        <? if ($category->description_full && $params->show_description): ?>
            <div class="docman_description">
                <?= prepareText($category->description_full); ?>
            </div>
        <? endif; ?>
    </div>
    <? endif; ?>

    <? // Tables ?>
    <form action="" method="get" class="k-js-grid-controller koowa_table_list">

        <? // Category table ?>
        <? if ($params->show_subcategories && count($subcategories)): ?>

            <? // Category header ?>
            <? if ($category->id && $params->show_categories_header): ?>
                <h3 class="koowa_header koowa_header--bottom_margin">
                    <?= $this->translate('Categories') ?>
                </h3>
            <? endif; ?>

            <? // Table ?>
            <table class="table table-striped koowa_table koowa_table--categories">
                <tbody>
                    <? foreach ($subcategories as $subcategory): ?>
                    <tr>
                        <td>
                            <span class="koowa_header">
                                <? if ($params->show_icon && $subcategory->icon): ?>
                                <span class="koowa_header__item koowa_header__item--image_container">
                                    <a class="iconImage" href="<?= $this->helper('route.category', array('entity' => $subcategory)) ?>">
                                        <?= $this->import('com://site/docman.document.icon.html', array('icon' => $subcategory->icon, 'class' => 'k-icon--size-default')) ?>
                                    </a>
                                </span>
                                <? endif ?>

                                <span class="koowa_header__item">
                                    <span class="koowa_wrapped_content">
                                        <span class="whitespace_preserver">
                                            <a href="<?= $this->helper('route.category', array('entity' => $subcategory)) ?>">
                                                <?= $this->escape($subcategory->title) ?>
                                            </a>
                                        </span>
                                    </span>
                                </span>
                            </span>
                        </td>

                        <? // Edit area | Import partial template from category view ?>
                        <?= $this->import('com://site/docman.category.manage.html', array('category' => $subcategory, 'redirect' => 'self', 'parent' => 'td', 'parentClass' => 'k-no-wrap')) ?>
                    </tr>
                    <? endforeach; ?>
                </tbody>
            </table>
        <? endif; ?>

        <? // Documents table | Import child template from documents view ?>
        <? if (count($documents) || ($params->show_document_search)): ?>
            <?= $this->import('com://site/docman.documents.table.html') ?>
        <? endif; ?>

        <? // Pagination ?>
        <? if ($this->parameters()->total): ?>
            <?= $this->helper('paginator.pagination', array(
                'show_limit' => (bool) $params->show_document_sort_limit
            )) ?>
        <? endif; ?>

    </form>
</div>
