<?php
/**
 * @package    DOCman
 * @copyright   Copyright (C) 2011 Timble CVBA (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */

class ComDocmanJobCache extends ComSchedulerJobAbstract
{
    protected function _initialize(KObjectConfig $config)
    {
        $config->append(array(
            'frequency' => ComSchedulerJobInterface::FREQUENCY_DAILY
        ));
    }

    public function run(ComSchedulerJobContextInterface $context)
    {
        JCache::getInstance('output', array('defaultgroup' => 'com_docman.files'))->clean();

        $context->state->clean = time();

        return $this->complete();
    }
}