<?php
/**
 * @package     LOGman
 * @copyright   Copyright (C) 2011 Timble CVBA. (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */

/**
 * Linker Controller
 *
 * @author  Arunas Mazeika <https://github.com/amazeika>
 * @package Joomlatools\Component\LOGman
 */
class ComLogmanControllerLinker extends ComKoowaControllerView
{
    /**
     * Passes the e_view parameter that Joomla sends in the request for the editor name.
     *
     * @see KControllerResource::getView()
     */
    public function getView()
    {
        $view = parent::getView();

        if ($view) {
            $view->editor = $this->getRequest()->query->e_name;
        }

        $request = $this->getRequest();

        if ($request->getFormat() == 'json')
        {
            $model = $this->getObject('com:activities.model.resources');

            $query = clone $request->getQuery();

            unset($query->levels);

            $model->getState()->setValues($query->toArray());

            $view->setModel($model);
        }

        return $view;
    }
}
