<?php
/**
 * @package    DOCman
 * @copyright   Copyright (C) 2011 Timble CVBA (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */

defined('_JEXEC') or die('Restricted access');

require_once JPATH_ROOT .'/components/com_komento/komento_plugins/abstract.php';

class KomentoComDocman extends KomentoExtension
{
    /**
     * This property (object) stores all the required properties by Komento.
     * (Refer to "load" method in Class methods)
     * @var
     */
    public $_item;

    /**
     * This property (array) stores all the key mappings of the required item
     * properties to map from Komento's default key to your component's custom key
     * @var array
     */
    public $_map = array(
        'id'            => 'id',
        'title'         => 'title',
        'created_by'    => 'created_by',
        'catid'         => 'docman_category_id',
        'permalink'     => 'link',
        'hits'          => 'hits'
    );

    public function getComponentName()
    {
        return JText::_('DOCman');
    }

    public function getComponentIcon()
    {
        return JUri::root(true).'/media/com_docman/images/joomlatools.png';
    }

    public function getEventTrigger()
    {
        return 'onContentAfterDisplay';
    }

    public function load($id)
    {
        static $instances = array();

        if (!class_exists('Koowa')) {
            return $this->onLoadArticleError($id);
        }

        if (!isset($instances[$id]))
        {
            $page = 'all';

            if (JFactory::getApplication()->isSite())
            {
                $active = JFactory::getApplication()->getMenu()->getActive();

                if ($active && $active->component === 'com_docman') {
                    $page = $active->id;
                }
            }

            $this->_item = KObjectManager::getInstance()->getObject('com://admin/docman.model.documents')
                ->id($id)
                ->page($page)
                ->fetch();

            $this->_item->link = $this->prepareLink(sprintf('index.php?option=com_docman&view=document&alias=%s&category_slug=%s&Itemid=%d',
                $this->_item->alias, $this->_item->category_slug, $this->_item->itemid));

            if (!$this->_item || $this->_item->isNew()) {
                return $this->onLoadArticleError($id);
            }

            $this->_item = (object) $this->_item->getProperties();

            $instances[$id] = $this->_item;
        }

        $this->_item = $instances[$id];

        return $this;
    }

    public function getContentIds($categories = '')
    {
        if (!class_exists('Koowa')) {
            return array();
        }

        $documents = KObjectManager::getInstance()->getObject('com://admin/docman.model.documents')
            ->page('all')
            ->categories($categories)
            ->limit(0)->sort('id')->fetch();

        $ids = array();
        foreach ($documents as $document) {
            $ids[] = $document->id;
        }

        return $ids;
    }

    public function getCategories()
    {
        if (!class_exists('Koowa')) {
            return array();
        }

        $categories = KObjectManager::getInstance()->getObject('com://admin/docman.model.categories')
            ->page('all')
            ->limit(0)
            ->sort('title')
            ->fetch();

        $return = array();
        foreach ($categories as $category)
        {
            $entity = new stdClass();

            $repeat = ( $category->level - 1 >= 0 ) ? $category->level - 1 : 0;

            $entity->treename = str_repeat( '.&#160;&#160;&#160;', $repeat ) . ( $category->level - 1 > 0 ? '|_&#160;' : '' ) . $category->title;
            $entity->id = $category->id;

            $return[] = $entity;
        }

        return $return;

    }

    // to determine if this is the Documents listing view
    public function isListingView()
    {
        return JFactory::getApplication()->input->getCmd('view', null) !== 'document';
    }

    // to determine if this is the Document view
    public function isEntryView()
    {
        return JFactory::getApplication()->input->getCmd('view', null) === 'document';
    }

    public function onExecute(&$article, $html, $view, $options = array())
    {
        // $html is the html content generated by Komento
        return $html;
    }
}